<?php

if (!defined('ABSPATH')) {
  exit;
}

final class Upword_Connect {
  const OPTION_KEY = 'upword_connect_options';

  public static function init() {
    require_once UPWORD_CONNECT_PLUGIN_DIR . 'includes/class-upword-rest.php';
    require_once UPWORD_CONNECT_PLUGIN_DIR . 'includes/class-upword-admin.php';

    load_plugin_textdomain('upword-connect', false, dirname(plugin_basename(UPWORD_CONNECT_PLUGIN_FILE)) . '/languages');

    Upword_Connect_Rest::init();
    Upword_Connect_Admin::init();
    add_shortcode('upword_json_ld', array(__CLASS__, 'shortcode_upword_json_ld'));
  }

  public static function shortcode_upword_json_ld() {
    $post_id = get_the_ID();
    if (!$post_id) {
      $post_id = get_queried_object_id();
    }
    if (!$post_id) {
      return '';
    }
    $json = get_post_meta($post_id, 'upword_json_ld', true);
    if ($json === '' || $json === false) {
      return '';
    }
    $json = str_replace('</script>', '<\/script>', (string) $json);
    return '<script type="application/ld+json">' . $json . '</script>';
  }

  public static function activate() {
    $defaults = array(
      'connected' => false,
      'connected_at' => null,
      'site_url' => home_url('/'),
      'shared_secret' => '',
      'seo_provider_preference' => 'auto', // auto|yoast|rankmath|custom
      'target_post_type' => 'post',
      'upword_connect_url' => 'https://www.goupword.com/connect/wordpress',
      'upword_api_base_url' => '', // Stored during connection for bidirectional sync
      'allowed_image_hosts' => 'cdn.goupword.com',
      'max_image_mb' => 10,
      'last_error' => '',
      'last_publish_at' => null,
      'last_publish_status' => null,
    );

    $existing = get_option(self::OPTION_KEY, null);
    if (!is_array($existing)) {
      add_option(self::OPTION_KEY, $defaults, '', false);
    } else {
      // Merge new defaults without overwriting existing values.
      update_option(self::OPTION_KEY, array_merge($defaults, $existing), false);
    }
  }

  public static function deactivate() {
    // Intentionally no-op: keep connection state and logs.
  }

  public static function get_options() {
    $opts = get_option(self::OPTION_KEY, array());
    return is_array($opts) ? $opts : array();
  }

  public static function update_options($patch) {
    $opts = self::get_options();
    $next = array_merge($opts, is_array($patch) ? $patch : array());
    update_option(self::OPTION_KEY, $next, false);
    return $next;
  }

  public static function clear_connection($error_message = '') {
    $patch = array(
      'connected' => false,
      'connected_at' => null,
      'shared_secret' => '',
      'last_error' => $error_message ? (string) $error_message : '',
      // Keep upword_client_id and upword_api_base_url for potential reconnection
    );
    return self::update_options($patch);
  }

  public static function set_connected($shared_secret, $site_url, $seo_provider_detected = 'custom', $additional_data = array()) {
    $patch = array(
      'connected' => true,
      'connected_at' => gmdate('c'),
      'shared_secret' => (string) $shared_secret,
      'site_url' => (string) $site_url,
      'last_error' => '',
    );

    if ($seo_provider_detected) {
      $patch['seo_provider_detected'] = (string) $seo_provider_detected;
    }

    // Store additional connection data (e.g., upword_client_id, upword_api_base_url)
    if (is_array($additional_data)) {
      if (isset($additional_data['upword_client_id'])) {
        $patch['upword_client_id'] = (string) $additional_data['upword_client_id'];
      }
      if (isset($additional_data['upword_api_base_url'])) {
        $patch['upword_api_base_url'] = (string) $additional_data['upword_api_base_url'];
      }
    }

    return self::update_options($patch);
  }
}

